//
// mailbox.c
//
// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Graphics_in_C_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "base.h"
#include "util.h"
#include "types.h"
#include "time.h"
#include "sys.h"

static void BcmMailBox_Flush(void)
{
	while (!(read32(MAILBOX0_STATUS) & MAILBOX_STATUS_EMPTY))
	{
		read32(MAILBOX0_READ);

		wait(20);
	}
}

static void BcmMailBox_Read(unsigned nChannel)
{
	u32 nResult;

	do
	{
		while (read32(MAILBOX0_STATUS) & MAILBOX_STATUS_EMPTY)
		{
			// do nothing
		}

		nResult = read32(MAILBOX0_READ);
	} while ((nResult & 0xF) != nChannel);  // channel number is in the lower 4 bits

}

static void BcmMailBox_Write(unsigned nChannel, u32 nData)
{
	while (read32(MAILBOX1_STATUS) & MAILBOX_STATUS_FULL)
	{
		// do nothing
	}

	//assert((nData & 0xF) == 0);
	write32( nChannel | nData, MAILBOX1_WRITE);  // channel number is in the lower 4 bits
}

void BcmMailBox_WriteRead(unsigned nChannel, u32 nData)
{
	PeripheralEntry();

	BcmMailBox_Flush();

	BcmMailBox_Write(nChannel, nData);

	BcmMailBox_Read(nChannel);

	PeripheralExit();

	
}
